/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.altran.sys.OsUtil;
import com.altran.sys.SystemOutLogging;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.panels.PathSelectionPanel;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class CustomPathSelectionPanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = 3257566217698292531L;
    protected PathSelectionPanel pathSelectionPanel;
    protected String emptyTargetMsg = this.getI18nStringForClass("empty_target", "TargetPanel");
    protected String warnMsg = this.getI18nStringForClass("warn", "TargetPanel");

    public CustomPathSelectionPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, new IzPanelLayout());
        String introText = this.getI18nStringForClass("extendedIntro", "PathInputPanel");
        if ((introText == null || introText.endsWith("extendedIntro") || introText.indexOf(36) > -1) && ((introText = this.getI18nStringForClass("intro", "PathInputPanel")) == null || introText.endsWith("intro"))) {
            introText = "";
        }
        this.add(this.createMultiLineLabel(introText));
        this.add(IzPanelLayout.createParagraphGap());
        this.add((Component)this.createLabel("info", "TargetPanel", "open", 2, true), "nextLine");
        this.pathSelectionPanel = new PathSelectionPanel(this, idata);
        this.add((Component)this.pathSelectionPanel, "nextLine");
        this.createLayoutBottom();
        this.getLayoutHelper().completeLayout();
    }

    public void createLayoutBottom() {
        String vers = System.getProperty("os.version");
        SystemOutLogging.printError("Check for Windows Vista and higer");
        if (OsUtil.isWindows() && vers.startsWith("6.")) {
            SystemOutLogging.printError("Showing warning for Windows Vista and higer");
            JTextArea lblWarningVista = new JTextArea(this.getI18nStringForClass("warningVista", "CustomTargetPanel") + "\n" + this.getI18nStringForClass("warningVista2", "CustomTargetPanel") + "\n" + this.getI18nStringForClass("warningVista3", "CustomTargetPanel"));
            lblWarningVista.setBackground(UIManager.getColor("Label.background"));
            lblWarningVista.setBorder(BorderFactory.createEmptyBorder());
            lblWarningVista.setFont(UIManager.getFont("Label.font"));
            lblWarningVista.setEditable(false);
            this.add((Component)lblWarningVista, "nextLine");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.pathSelectionPanel.getPathInputField()) {
            this.parent.navigateNext();
        }
    }

    public boolean isWriteable() {
        File existParent = IoHelper.existingParent(new File(this.pathSelectionPanel.getPath()));
        if (existParent == null) {
            return false;
        }
        if (OsVersion.IS_WINDOWS) {
            try {
                File tmpFile = File.createTempFile("izWrTe", ".tmp", existParent);
                tmpFile.deleteOnExit();
            }
            catch (IOException e) {
                Debug.trace(e.toString());
                return false;
            }
            return true;
        }
        return existParent.canWrite();
    }

    @Override
    public void panelActivate() {
        super.panelActivate();
        this.pathSelectionPanel.setPath(this.idata.getInstallPath());
    }

    @Override
    public boolean isValidated() {
        boolean ok = true;
        String chosenPath = this.pathSelectionPanel.getPath();
        if (chosenPath.isEmpty()) {
            ok = this.emitWarning(this.parent.langpack.getString("installer.warning"), this.emptyTargetMsg);
        }
        if (!ok) {
            return false;
        }
        if (chosenPath.startsWith("~")) {
            String home = System.getProperty("user.home");
            chosenPath = home + chosenPath.substring(1);
        }
        File path = new File(chosenPath).getAbsoluteFile();
        chosenPath = path.toString();
        this.pathSelectionPanel.setPath(chosenPath);
        if (!this.isWriteable()) {
            this.emitError(this.parent.langpack.getString("installer.error"), this.getI18nStringForClass("notwritable", "TargetPanel"));
            return false;
        }
        if (path.exists()) {
            if (this.areFilesInUse(path.toPath())) {
                this.emitFileInUseError();
                ok = false;
            } else {
                File versionFile = new File(path, "version");
                if (versionFile.exists()) {
                    try (FileInputStream fis = new FileInputStream(versionFile);){
                        Properties properties = new Properties();
                        properties.load(fis);
                        String existingVersion = properties.getProperty("Version");
                        String currentVersion = this.idata.getVariable("APP_VER");
                        if (this.isAppInUse(existingVersion)) {
                            this.emitFileInUseError();
                            ok = false;
                        } else if (existingVersion != null && currentVersion != null) {
                            ok = this.getAskedQuestionResult(existingVersion, currentVersion) == 47;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            String vStr = this.idata.getVariable("ShowCreateDirectoryMessage");
            if (vStr == null || Boolean.getBoolean(vStr)) {
                ok = this.emitNotificationFeedback(this.getI18nStringForClass("createdir", "TargetPanel") + "\n" + chosenPath);
            }
        }
        if (ok) {
            this.idata.setInstallPath(this.pathSelectionPanel.getPath());
            return true;
        }
        return false;
    }

    private void emitFileInUseError() {
        this.emitError(this.parent.langpack.getString("CustomPathSelectionPanel.files.in.use.title"), this.parent.langpack.getString("CustomPathSelectionPanel.files.in.use.message"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAppInUse(String version) {
        if (version == null) return false;
        if (!OsUtil.isMacOS()) return false;
        try {
            ProcessBuilder psBuilder = new ProcessBuilder("ps", "aux");
            psBuilder.redirectErrorStream(true);
            Process psProcess = psBuilder.start();
            try (BufferedReader psReader = new BufferedReader(new InputStreamReader(psProcess.getInputStream()));){
                String line;
                String searchTerm = "app/main-" + version + ".jar";
                do {
                    if ((line = psReader.readLine()) == null) return false;
                } while (!line.contains(searchTerm));
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private int getAskedQuestionResult(String existingVersion, String currentVersion) {
        String existingVersionPrefix = this.getVersionPrefix(existingVersion);
        String currentVersionPrefix = this.getVersionPrefix(currentVersion);
        int comparison = this.compareVersions(existingVersionPrefix, currentVersionPrefix);
        switch (comparison) {
            case -1: {
                return this.askQuestion(this.parent.langpack.getString("CustomPathSelectionPanel.version.detection.title"), this.parent.langpack.getString("CustomPathSelectionPanel.older.version.detected"), 37, 47);
            }
            case 0: {
                return this.askQuestion(this.parent.langpack.getString("CustomPathSelectionPanel.version.detection.title"), this.parent.langpack.getString("CustomPathSelectionPanel.same.version.detected"), 37, 47);
            }
            case 1: {
                this.emitError(this.parent.langpack.getString("CustomPathSelectionPanel.version.detection.title"), this.parent.langpack.getString("CustomPathSelectionPanel.future.version.detected"));
                return 45;
            }
        }
        return 45;
    }

    @Override
    public String getSummaryBody() {
        return this.idata.getInstallPath();
    }

    private String getVersionPrefix(String version) {
        String[] parts = version.split("-");
        return parts[0];
    }

    private int compareVersions(String version1, String version2) {
        String[] v1Parts = version1.split("\\.");
        String[] v2Parts = version2.split("\\.");
        for (int i = 0; i < 3; ++i) {
            int v2Part;
            int v1Part = Integer.parseInt(v1Parts[i]);
            if (v1Part < (v2Part = Integer.parseInt(v2Parts[i]))) {
                return -1;
            }
            if (v1Part <= v2Part) continue;
            return 1;
        }
        return 0;
    }

    private boolean areFilesInUse(Path directory) {
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    try {
                        RandomAccessFile raf = new RandomAccessFile(file.toFile(), "rw");
                        raf.close();
                    }
                    catch (IOException e) {
                        throw new FileInUseException(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (FileInUseException e) {
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static class FileInUseException
    extends RuntimeException {
        private final Path file;

        public FileInUseException(Path file) {
            this.file = file;
        }

        public Path getFile() {
            return this.file;
        }
    }
}

