/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.altran.sys.OsUtil;
import com.altran.sys.SystemOutLogging;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import java.awt.Component;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class CheckInstancePanel
extends IzPanel
implements ActionListener {
    private JCheckBox instanceCheckbox;

    public CheckInstancePanel(InstallerFrame parent, InstallData idata) {
        this(parent, idata, new IzPanelLayout());
    }

    public CheckInstancePanel(InstallerFrame parent, InstallData idata, LayoutManager2 layout) {
        super(parent, idata, layout);
        String str = "<html><h3>" + parent.langpack.getString("CheckInstancePanel.Title") + "</h3></html>";
        JLabel labelTmp = LabelFactory.create(str, 10);
        this.add((Component)labelTmp, "nextLine");
        this.add((Component)new JLabel(" "), "nextLine");
        labelTmp = LabelFactory.create(parent.langpack.getString("CheckInstancePanel.Desc"), 10);
        this.add((Component)labelTmp, "nextLine");
        this.add((Component)new JLabel(" "), "nextLine");
        this.instanceCheckbox = new JCheckBox(parent.langpack.getString("CheckInstancePanel.CheckboxText"));
        this.instanceCheckbox.addActionListener(this);
        this.add((Component)this.instanceCheckbox, "nextLine");
        this.getLayoutHelper().completeLayout();
        SystemOutLogging.printError("==> os.name = " + OsUtil.getOsName());
        SystemOutLogging.printError("==> os.version = " + System.getProperty("os.version"));
        SystemOutLogging.printError("==> Is64bits = " + idata.getVariable("Is64bits"));
        boolean Is64bits = Boolean.parseBoolean(idata.getVariable("Is64bits"));
        String str64bits = "";
        if (Is64bits) {
            str64bits = "_x64";
        }
        if (OsUtil.isWindows()) {
            idata.setInstallPath("C:" + File.separator + idata.getVariable("APP_NAME") + File.separator + idata.getVariable("APP_VER") + str64bits);
            SystemOutLogging.printError("Force Install path to : " + idata.getInstallPath());
        }
    }

    @Override
    public boolean isValidated() {
        return true;
    }

    @Override
    public void panelActivate() {
        super.panelActivate();
        this.updateCheckboxState();
    }

    private void updateCheckboxState() {
        if (this.instanceCheckbox.isSelected()) {
            this.getInstallerFrame().unlockNextButton(true);
        } else {
            this.getInstallerFrame().lockNextButton();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.instanceCheckbox) {
            this.updateCheckboxState();
        }
    }
}

